#pragma rtGlobals=1		// Use modern global access method.


Function EDF(Key)
	STRING key
//	string allfolder=ListFolder()
//	variable i

	

//	for(i=0;i<ItemsInList(allfolder)-3;i+=1)
//		SetDataFolder $stringfromlist(i,allfoder)
		String ALLIwaves = Wavelist(key,";","")
		make/O/n=(ItemsInList(allIwaves)) I_Avg
		variable i	
		
		string wavenote,Rseries,name
		variable Rs
		
		for(i=0; i<ItemsInList(allIwaves);i+=1)
			wave Imon=$StringFromList(i,ALLIWaves,";")		
			I_Avg[i] =  mean(Imon,pnt2x(Imon,10000),pnt2x(Imon,11900))-mean(Imon,pnt2x(Imon,5000),pnt2x(Imon,6500))			
			wavenote=note(Imon)
			Rseries=stringbykey("\rRsValue",wavenote)			
			Rs=str2num(Rseries)*10^6	
			if(Rs==0)
				Rseries=stringbykey("\rRseries",wavenote)
				Rs=str2num(Rseries)*10^6	
			endif
			print Rs	
		endfor
		I_Avg = I_Avg* 1e12
		print mean(I_avg)
	
End


function ShowTraces(key)
	string key

	string aICa
//	string aF=ListFolder()
	DFREF home=getdatafolderDFR()
	
	variable i,j
//	for(i=0;i<ItemsInList(aF)-1;i+=1)
//		setdatafolder $StringFromList(i,aF)
		aICa=wavelist(key,";","")
		Display $StringFromList(0,aICa)
		for(j=1;j<ItemsInLIst(aICa);j+=1)
			AppendToGraph $StringFromList(j,aICa)
		endfor
//		setdatafolder home
//	endfor

end

function ShowTraces2()
	string aF=ListFolder()
	DFREF home=getdatafolderDFR()
	
	variable i,j
	for(i=0;i<ItemsInList(aF)-1;i+=1)
		setdatafolder $StringFromList(i,aF)
		setdatafolder IV
		wave aICa=$"I_Avg"
		wave vCa=$"V_Avg"
		if(vCa[0]>-0.075)
			vCa=vCa-0.017
		endif		
		IVr()
		
		ActivCurve(aICa,vCa,0)
		wave fit_Pia
		if(i==0)
			Display/L=P/B=V fit_Pia
		endif
		appendtograph/L=P/B=V fit_Pia
		
		setdatafolder home
	endfor

end

function CheckTraces2()
	string aF=ListFolder()
	
	DFREF home=getdatafolderDFR()
	newdatafolder/S tFV
	DFREF Dest=getdatafolderDFR()
	setdatafolder root:
	variable/G TN
	DFREF Mother=getdatafolderDFR()
	setdatafolder home
	string NewName
	
	variable i,j
	j=TN
	for(i=0;i<ItemsInList(aF)-2;i+=1)
		j=j+1
		setdatafolder $StringFromList(i,aF)		
		setdatafolder FPopen_CaVr
		NewName="Pact_"+num2str(j)
		wave/Z fit_Cor_Po
//		print DimOffset(fit_Pia,0),DimDelta(fit_pia,0)
		duplicate fit_Cor_Po, $NewName
		movewave $NewName,Dest
				
		setdatafolder home
	endfor
	setdatafolder Mother
	TN=j

end

function getALfit()
	string aF=ListFolder()
	
	DFREF home=getdatafolderDFR()
	newdatafolder/S TtFV
	DFREF Dest=getdatafolderDFR()
	setdatafolder home
	string aW
	variable i,j
	for(i=0;i<ItemsInList(aF)-2;i+=1)
		setdatafolder $StringFromList(i,aF)
		setdatafolder tFV
		aW=Wavelist("Pact_*",";","")
		for(j=0;j<ItemsInList(aW);j+=1)
			wave w=$stringfromlist(j,aW)
			movewave w,Dest
		endfor
		setdatafolder home
	endfor
end

function addall()
	string Alw=wavelist("*",";","")
	make/O/n=200 Pact,SDact,SDactP,SDactN
//	make/O/n=(ItemsInList(Alw)) Offw,Deltaw
	variable j,On,Off,MiNN,MaXX
	string RsName
	for(j=0;j<ItemsInList(AlW);j+=1)
		wave w=$stringfromlist(j,Alw)
		On=x2pnt(w,-0.085)
		Off=x2pnt(w,0.005)
		Duplicate/O/R=[On,Off] w,wt		
		Resample/Rate=1000 Wt
		MiNN= mean(Wt,pnt2x(Wt,0),pnt2x(wt,5))
		Maxx=Wt[x2pnt(Wt,0)]
		Wt=(Wt-miNN)/(Maxx-miNN)
		if(numpnts(wt)==90)
			Deletepoints/M=0 89,1,wt
		endif
		concatenate/NP=1 {wt},wMatrix		
//		Offw[j]=Dimoffset(w,0)
//		Deltaw[j]=Delta+DimDelta(w,0)
	endfor
//	Off=mean(Offw)
//	Delta=mean(Deltaw)
	for(j=0;j<200;j+=1)
		duplicate/O/R=[j,j][] wMatrix,Temp
		matrixtranspose Temp
		Redimension/n=(-1,0) Temp
		Pact[j]=mean(Temp)
		SDact[j]=sqrt(variance(Temp))
	endfor
	SDactP=Pact+SDact
	SDactN=Pact-SDact
	killwaves Temp
	setscale/P x,Off,0.001,Pact,SDactP,SDactN
	
end



function CalSigAll()
	string Alw=wavelist("Pact*",";","")
	make/n=(ItemsInList(Alw)) Vh_value,K_value
	variable j,i
	string waveN
	for(j=0;j<ItemsInList(AlW);j+=1)
		wave w2=$stringfromlist(j,Alw)
		curvefit/Q/NTHR=0 Sigmoid  w2(-0.087,0.013)/D
		wave w_coef
		Vh_Value[j]=W_Coef[2]
		k_value[j]=W_Coef[3] 
	endfor	
end


Function TraceSlider()
	String grfName= WinName(0, 1)
//	
	DoWindow/F $grfName
	if( V_Flag==0 )
		return 0			// no top graph, exit
	endif

	String TracesName= TraceNameList("",";",1)		// find one top image in the top graph window
	if( strlen(TracesName) == 0 )
		DoAlert 0,"No image plot found"
		return 0
	endif
			
	
	
	ControlInfo kwControlBar
	Variable/G gOriginalHeight= V_Height		// we append below original controls (if any)
	ControlBar gOriginalHeight+60
	
	ControlInfo TraceSlider
	if( V_Flag != 0 )
		return 0			// already installed, do nothing
	endif
	
	getwindow kwTopWin ,gSize
	wave w=TraceNameToWaveRef(grfName, stringfromlist(0,TracesName))
//	DFREF TrF=getwavesdatafolderDFR(w)
//	setdatafolder TrF 
	
	
	variable/G TraceNr
	
	slider TraceSlider limits={0,ItemsInList(TracesName),1},Proc=showatrace,vert=0,side=1
	slider TraceSlider size={V_Right-V_Left+20,V_top},pos={V_Left+10,gOriginalHeight}
	button ShowMeanB size={50,50},pos={V_Right+40,gOriginalHeight+5},title="show\rmean",proc=ShowMean

//	modifyimage $iName ctab= {Var,*,Grays,0}
End

Function TraceSliderFVfit()
	String grfName= WinName(0, 1)
//	
	DoWindow/F $grfName
	if( V_Flag==0 )
		return 0			// no top graph, exit
	endif

	String TracesName= TraceNameList("",";",1)		// find one top trace in the top graph window
	if( strlen(TracesName) == 0 )
		DoAlert 0,"No trace plot found"
		return 0
	endif
			
	
	
	ControlInfo kwControlBar
	Variable/G gOriginalHeight= V_Height		// we append below original controls (if any)
	ControlBar gOriginalHeight+60
	
	ControlInfo TraceSliderFV
	if( V_Flag != 0 )
		return 0			// already installed, do nothing
	endif
	
	getwindow kwTopWin ,gSize
//	wave w=TraceNameToWaveRef(grfName, stringfromlist(0,TracesName))
//	DFREF TrF=getwavesdatafolderDFR(w)
//	setdatafolder TrF 
	
	
	variable/G TraceNr
	
	slider TraceSliderFV limits={0,ItemsInList(TracesName),1},Proc=showatraceFV,vert=0,side=1
	slider TraceSliderFV size={V_Right-V_Left+20,V_top},pos={V_Left+10,gOriginalHeight}
//	button ShowMeanB size={50,50},pos={V_Right+40,gOriginalHeight+5},title="show\rmean",proc=ShowMean

//	modifyimage $iName ctab= {Var,*,Grays,0}
End

function showatraceFV(name,value,event)
	string Name
	variable value,event
	
	variable TNr=value
	
	
	string TracesName= TraceNameList(winname(0,1),";",1)
	string grfname=winname(0,1)
	wave w=TraceNameToWaveRef(grfName, stringfromlist(TNr,TracesName))
	variable Ma=FindtracesExtreme(0)
	variable mi=FindtracesExtreme(1)
	
	DFREF home=getdatafolderdfr()
	DFREF TrF=getwavesdatafolderDFR(w)
	
	string cmd
	
	variable j
	for(j=0;j<ItemsInList(TracesName);j+=1)	
		wave w2=TraceNameToWaveRef(grfName, stringfromlist(j,TracesName))
		DFREF TrF2=getwavesdatafolderDFR(w2)
		if(j!=TNr && DataFolderRefsEqual(TrF,TrF2)!=1)
			ModifyGraph hideTrace($stringfromlist(j,TracesName))=1
		else
			ModifyGraph hideTrace($stringfromlist(j,TracesName))=0
			setaxis FCa mi,Ma
			setdatafolder TrF
			wave W_Coef
			sprintf cmd, "\Z12\\f01\\K(0,0,0)%g,%g",W_Coef[2],W_Coef[3]
			TextBox/W=$grfname/C/N=para/F=0/A=MT cmd
			setdatafolder home 
		endif
		
	endfor
	setdatafolder home
	if(TNr==ItemsInList(TracesName))
		for(j=0;j<ItemsInList(TracesName);j+=1)	
			ModifyGraph hideTrace($stringfromlist(j,TracesName))=0
			setaxis FCa mi,Ma
		endfor
	endif	
end


function showatrace(name,value,event)
	string Name
	variable value,event
	
	controlinfo traceslider
	variable TNr=V_Value
	
	
	string TracesName= TraceNameList(winname(0,1),";",1)
	string grfname=winname(0,1)
	wave w=TraceNameToWaveRef(grfName, stringfromlist(0,TracesName))
	variable Ma=FindtracesExtreme(0)
	variable mi=FindtracesExtreme(1)
	
	DFREF TrF=getwavesdatafolderDFR(w)
	setdatafolder TrF
	variable j
	for(j=0;j<ItemsInList(TracesName);j+=1)	
		if(j!=TNr)
			ModifyGraph hideTrace($stringfromlist(j,TracesName))=1
		else
			ModifyGraph hideTrace($stringfromlist(j,TracesName))=0
			setaxis left mi,Ma
		endif
	endfor
	if(TNr==ItemsInList(TracesName))
		for(j=0;j<ItemsInList(TracesName);j+=1)	
			ModifyGraph hideTrace($stringfromlist(j,TracesName))=0
			setaxis left mi,Ma
		endfor
	endif	
end

function/D FindtracesExtreme(f)
	variable f
	
	variable Ma,mi,i,TMa,Tmi
	string Trst= TraceNameList(winname(0,1),";",1)
	string grfname=winname(0,1)
	wave w=TraceNameToWaveRef(grfName, stringfromlist(0,Trst))
	DFREF home=getdatafolderDFR()
	DFREF TrF=getwavesdatafolderDFR(w)
	setdatafolder TrF
	Ma=wavemax(w)
	mi=wavemin(w)
	setdatafolder home	
	
	for(i=1;i<itemsinlist(Trst);i+=1)
		wave w=TraceNameToWaveRef(grfName, stringfromlist(i,Trst))
		DFREF TrF=getwavesdatafolderDFR(w)
		setdatafolder TrF
		TMa=wavemax(w)
		Tmi=wavemin(w)
		if(TMa>Ma)
			Ma=TMa
		endif
		if(Tmi<mi)
			mi=Tmi
		endif
		setdatafolder home
	endfor
	switch(f)
		case 0:
			return Ma
			break
		case 1:
			return mi
			break
	endswitch
end

Function ShowMean(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			wave I_Avg
			display I_Avg
			ModifyGraph mode=4,marker=19,msize=2
			string CellName=getwavesdatafolder(I_Avg,0)
			TextBox/C/N=text0/F=0/A=MC/X=0.95/Y=3.37 CellName
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End

function DispImon()

	string Imons=WaveList("*_Imon",";","")
	variable j
	DFREF home=getdatafolderdfr()
		
	Display $StringFromList(0,Imons)
	for(j=1;j<ItemsInLIst(Imons);j+=1)
		AppendToGraph $StringFromList(j,Imons)
	endfor
	traceslider()

//	Imons=WaveList("*_Leak_1",";","")
//	Display $StringFromList(0,Imons)
//	for(j=1;j<ItemsInLIst(Imons);j+=1)
//		AppendToGraph $StringFromList(j,Imons)
//	endfor
//	traceslider()
//			
//	setdatafolder plus_leak
//	
//	Imons=WaveList("nImon_*",";","")
//	Display $StringFromList(0,Imons)
//	for(j=1;j<ItemsInLIst(Imons);j+=1)
//		AppendToGraph $StringFromList(j,Imons)
//	endfor
//	EDF("nImon_*")
//	traceslider()
//	setdatafolder home	

end

function DispVmon()

	string Vmons=WaveList("*_Vmon",";","")
	variable j
	DFREF home=getdatafolderdfr()
		
	Display $StringFromList(0,Vmons)
	for(j=1;j<ItemsInLIst(Vmons);j+=1)
		AppendToGraph $StringFromList(j,Vmons)
	endfor
	traceslider()

end

function LeakBack(ind)
	variable ind

	string Imons,leaks
	string uN
	
	variable j,i
	
	DFREF home=getdatafolderDFR()
	
//	string Fs=ListFolder()
	
//	for(i=0;i<ItemsInList(Fs)-1;i+=1)
//		setdatafolder $stringfromlist(i,Fs)
		NewDataFolder/O plus_Leak
		Imons=WaveList("*_Imon",";","")
		Leaks=Wavelist("*_Leak_1",";","")
		for(j=0;j<ItemsInLIst(Imons);j+=1)
			wave w=wavecalculatorw(0,$stringfromlist(j,Imons),$stringfromlist(j,Leaks))
			uN="uImon_"+num2str(j)
			rename w, $uN
			movewave :$uN, :plus_Leak:
		endfor
//		setdatafolder home
//	endfor

	if(ind==1)
		setdatafolder plus_leak
		variable Zero
		uN=wavelist("uImon*",";","")
		for(i=0;i<ItemsInList(uN);i+=1)
			wave w=$stringfromlist(i,uN)
			zero=mean(w,0.001,0.005)
			w=w-zero
		endfor
	endif	

end

function LeakCorrection()
	variable i,j
	string Leaks=wavelist("*Leak_1",";","")
	
	for(j=0;j<ItemsInList(Leaks);j+=1)
		wave w=$stringfromlist(j,Leaks)
		string wN="cL_"+nameofwave(w)
		make/O/n=(DimSize(w,0)) $wn
		wave u=$wn
		setscale/P x,DimDelta(w,0),u
		
	
		string fitname
		wavestats/R=[0,7000]/w w
		curvefit/NTHR=1/K={V_minloc} dblexp_XOffset w[0,7000]/D	
		fitname="fit_"+nameofwave(w)
		wave V=$fitname
		rename v,Fit1st	
//		wave w_Coef
//		for(i=0;i<7000;i+=1)
//			u[i]=W_coef[0]+w_coef[1]*exp((V_minloc-pnt2x(u,i))/w_coef[2])+w_coef[3]*exp((V_minloc-pnt2x(u,i))/w_coef[4])
//		endfor
//		killvariables/A
	
		wavestats/R=[7000,12000]/w w
		CurveFit/NTHR=1/K={V_maxloc} dblexp_XOffset w[V_maxRowloc,12000] /D
		fitname="fit_"+nameofwave(w)
		wave V=$fitname
		rename v,Fit2nd
		wave w_Coef
		for(i=7000;i<12000;i+=1)
			u[i]=W_coef[0]+w_coef[1]*exp((V_maxloc-pnt2x(u,i))/w_coef[2])+w_coef[3]*exp((V_maxloc-pnt2x(u,i))/w_coef[4])
		endfor
		killvariables/A
	
		wavestats/R=[12000,19000]/w w
		CurveFit/NTHR=1/K={V_minloc} dblexp_XOffset w[V_minRowloc,19000] /D
		wave V=$fitname
		rename v,Fit3rd
//		wave w_Coef
//		for(i=12000;i<19000;i+=1)
//			u[i]=W_coef[0]+w_coef[1]*exp((V_minloc-pnt2x(u,i))/w_coef[2])+w_coef[3]*exp((V_minloc-pnt2x(u,i))/w_coef[4])
//		endfor
//		killvariables/A
		movewave u, :plus_leak:
		killwaves M_wavestats,W_Coef,Fit1st,Fit2nd,Fit3rd,w_fitconstants,W_sigma
	endfor


end

function leak3overlap()
	string aF=ListFolders("*")
	string Leaks
	string nName
	string uImons
	variable i,j
	DFREF home=GetDataFolderDFR()
	for(i=ItemsInList(aF)-3;i<ItemsInList(aF)-1;i+=1)
		setdatafolder $stringfromlist(i,aF)
		leaks=wavelist("*_leak_1",";","")
		DFREF FF=GetDataFolderDFR()
		for(j=0;j<ItemsInList(leaks);j+=1)
//			make/O Leak
			wave/Z Lk1=$stringfromlist(j-1,leaks)
			wave/Z Lk2=$stringfromlist(j,leaks)
			wave/Z Lk3=$stringfromlist(j+1,leaks)
			if(j==0)
				wave Leak=wavecalculatorW(0,Lk2,Lk3)
				Leak=Leak/2
			elseif(j==ItemsInList(leaks)-1)
				wave Leak=wavecalculatorW(0,Lk1,Lk2)
				Leak=Leak/2
			else
				wave temp=wavecalculatorW(0,Lk2,Lk3)
				rename temp,temp
				wave Leak=wavecalculatorW(0,temp,Lk1)
				killwaves temp
				Leak=Leak/3
			endif
			rename Leak,Leak
			movewave Leak, :Plus_Leak:
			setdatafolder Plus_Leak
			uImons=wavelist("uImon_*",";","")
			make/O nImon
			wave u1=$stringfromlist(j,uImons)
			wave nImon=wavecalculatorW(1,u1,Leak)
			nName="nImon_"+num2str(j)
			rename nImon,$nName
			killwaves Leak
			setdatafolder FF
		endfor
		setdatafolder home
	endfor
end


function Thevenin()
	make/O/n=1000 Rth
	variable i
	
	for(i=0;i<DimSize(Rth,0);i+=1)
		Rth[i]=(100*i)/(10+i*10)
	endfor

end

function ImonMean(on,off)
	variable on,off
	setdatafolder Plus_Leak
	string Imons=Wavelist("nImon_*",";","")
	variable i
	
	wave w=wavecalculatorw(0,$stringfromlist(0,Imons),$stringfromlist(1,Imons))
	for(i=on;i<=off;i+=1)
		wave N=$stringfromlist(i,Imons)	
		w=w+N	
	endfor
	w=w/(Off-On+1)
	string In="Imon_Mean"+num2str(on)+"_"+num2str(off)
	rename w,$In
end
 
 function LeakMinus()
 	string Oimon=wavelist("uimon*",";","")
 	string CLeak=wavelist("cL_*",";","")
 	variable i
 	string Nn
 	for(i=0;i<ItemsInList(Oimon);i+=1)
 		wave w=wavecalculatorW(1,$stringfromlist(i,Oimon),$stringfromlist(i,cleak))
 		Nn="nImon_"+num2str(i)
 		rename w, $Nn
 	endfor
 end
 
function QcaInt()
	string Fs=ListFolder()
	DFREF home=getdatafolderdfr()
	string ImeanN
	string ItName
	variable i,QvCa
	make/O/n=(ItemsInList(Fs)-1) QCa,PeakCa,MeanCa
	make/T/O/n=(ItemsInList(Fs)-1) NameCa
	for(i=0;i<ItemsInList(Fs)-1;i+=1)
		NameCa[i]=stringfromlist(i,Fs)
		setdatafolder $stringfromlist(i,Fs)
		setdatafolder :plus_leak
		ImeanN=stringfromlist(0,wavelist("Imon_Mean*",";",""))
		print ItemsInList(wavelist("Imon_Mean*",";",""))
		wave Imon_Mean=$ImeanN
		if(i==0)
			display Imon_Mean
		else
			AppendToGraph Imon_Mean
		endif
		ItName="Int_"+NameOfWave(Imon_Mean)
		Integrate Imon_Mean/D=$ItName		
		wave It=$ItName
		Qvca=(It[7000]-It[12000])
		QCa[i]=QvCa
		PeakCa[i]=wavemin(Imon_Mean,pnt2x(Imon_Mean,7000),pnt2x(Imon_Mean,12000))-mean(Imon_Mean,pnt2x(Imon_Mean,1000),pnt2x(Imon_Mean,5000))
		MeanCa[i]=Mean(Imon_Mean,pnt2x(Imon_Mean,10000),pnt2x(Imon_Mean,12000))-mean(Imon_Mean,pnt2x(Imon_Mean,1000),pnt2x(Imon_Mean,5000))
		setdatafolder home
	endfor
end

function DispMean()
	
	string Imons
	variable i,j
	string Fs=ListFolder()
	DFREF home=getdatafolderdfr()
	
	for(i=0;i<ItemsInList(Fs)-1;i+=1)
		setdatafolder $stringfromlist(i,Fs)
		setdatafolder plus_leak		
		Imons=stringfromlist(0,wavelist("Imon_Mean*",";",""))
		wave Imon_Mean=$Imons
		if(i==0)
			display Imon_Mean
		else
			AppendToGraph Imon_Mean
		endif
		setdatafolder home
	endfor
	traceslider()
	
end

function RSCacrossFolders(Trs)
	variable Trs
	string aF=ListFolder()
	DFREF home=GetDataFolderDFR()
	string fn
	variable i
	for(i=0;i<ItemsInList(aF)-1;i+=1)
		fn="Section_"+num2str(i)
		setdatafolder $fn
		RSC(Trs)
		setdatafolder home
	endfor
end

function RsCorrect()
	
	DFREF home=Getdatafolderdfr()
	string AF1=ListFolder()
	setdatafolder CaTraces
	DFREF h2=getdatafolderDFR()	
	string AF2=ListFolder()
	variable i,j,k
	string WN,Vn
	
	
	for(i=0;i<ItemsInList(AF2)-1;i+=1)
		setdatafolder $stringfromlist(i,AF2)
		DFREF target=getdatafolderdfr()
		wave Imon=$stringfromlist(0,wavelist("*Imon",";",""))
		j=0
		do
			setdatafolder home
			setdatafolder $stringfromlist(j,AF1)
			WN=wavelist(NameOfWave(Imon),";","") 
			j=j+1
		while(j<ItemsInList(AF1)-1 && stringmatch(WN,"")==1)
		Vn=wavelist("*Vmon",";","")
		wave Vmon=$stringfromlist(0,Vn)
		Vn=NameOfWave(Vmon)
		duplicate Vmon, VmonTemp
		movewave VmonTemp, target
		setdatafolder target
		duplicate VmonTemp, $NameOfWave(Vmon)
		killwaves VmonTemp
		setdatafolder h2
	endfor
	

end

function RSC(Trs)//Old Igor files have Imon Vmon (before 25/10/15), new have I-mon V-mon
	variable Trs //resample interval for VmonSlow
	DFREF home=getdatafolderDFR()	
//	string AF=ListFolder()
	string aw=wavelist("*I-mon",";","")
	variable i,j,k
	string wavenote,Rseries,VmonC,VmonS
	variable Rs
	
	for(i=0;i<ItemsInList(aw);i+=1)
//		setdatafolder $stringfromlist(i,AF)
		killwaves/Z VmonSlow,VmonCor
		wave Imon=$stringfromlist(i,wavelist("*I-mon",";",""))
		wave Vmon=$stringfromlist(i,wavelist("*V-mon",";",""))	
	
		wavenote=note(Imon)
		Rseries=stringbykey("\rRsValue",wavenote)
		Rs=str2num(Rseries)*10^6
		if(Rs==0)
			Rseries=stringbykey("\rRSeries",wavenote)
			Rs=str2num(Rseries)*10^6					
		endif
		
		VmonC="VmonCor_"+num2str(i+1)
		
		make/O/n=(DimSize(Vmon,0)) $VmonC
		Wave VmonCor=$VmonC
		VmonCor=Vmon-Imon*Rs
		VmonS="VmonSlow_"+num2str(i+1)
		setscale/P x 0,deltax(Vmon), VmonCor
		
		wave VmonSlow=$VmonS
		if(waveexists(VmonSlow)!=0)
			killwaves VmonSlow
		endif		
		make/O/n=0 $VmonS
		wave VmonSlow=$VmonS
		
		k=-1
		for(j=0+Trs/2*deltax(Vmon);j<Dimsize(VmonCor,0);j+=Trs/deltax(Vmon))
			k=k+1
			Insertpoints/M=0 DimSize(VmonSlow,0),1,VmonSlow
			VmonSlow[k]=VmonCor[j]	
		endfor
		setscale/P x 0,Trs, VmonSlow 
		
		setdatafolder home
			
	endfor
	
end

function SamplingV(F,V)
	
	wave F,V
	
	variable i,Xt
	
	make/n=(numpnts(F)) Vslow
	
	for(i=0;i<numpnts(F);i+=1)
		Xt=x2pnt(V,pnt2x(F,i))
		Vslow[i]=V[Xt]
	endfor

end

function DispRIV()
	string aF=ListFolder()
	DFREF home=getdatafolderDFR()
//	string Imons
	string PrevImN=""
	
	variable i,j=0
	make/O/n=(ItemsInList(aF)-2) RVh,RVk 
	
	for(i=0;i<ItemsInList(aF)-2;i+=1)
		setdatafolder :$stringfromlist(i,aF)
		wave Imons=$stringfromlist(0,wavelist("PDep*_1",";",""))	
		if(stringmatch(PrevImN,NameofWave(Imons))!=1)
			wave Vmons=$stringfromlist(0,wavelist("VmonCor",";",""))	
			if(i==0)
				Display Imons
				Duplicate Imons,MeanMon
				movewave MeanMon, home
			else
				AppendToGraph Imons
				duplicate Imons,TempMon
				movewave TempMon,home
			endif
			ActivCurve(Imons,Vmons,1)
			variable/G Vh,k
			setdatafolder home
			if(i!=0)
				MeanMon=MeanMon+TempMon
				killwaves TempMon
			endif
			RVh[j]=Vh
			RVk[j]=k
			J=J+1
			PrevImN=NameOfWave(ImonS)
		endif
		setdatafolder home
	endfor
end

function DispFV()
	string aF=ListFolder()
	DFREF home=getdatafolderDFR()
//	string Imons
	
	variable i,j=0
	for(i=0;i<ItemsInList(aF)-3;i+=1)
		setdatafolder :$stringfromlist(i,aF)
		wave Fmons=$stringfromlist(0,wavelist("Avg_*",";",""))
		setscale/P x,0,0.005,Fmons
		appendToGraph/L=FCa Fmons
		if(i==0)
//			Display Fmons
			Duplicate Fmons,MeanFMon
			movewave MeanFMon, home
		else
			duplicate Fmons,TempFMon
			movewave TempFMon,home
		endif
		setdatafolder home
		if(i!=0)
			MeanFMon=MeanFMon+TempFMon
			killwaves TempFMon
		endif
		
	endfor			
end

function DispFV2(index) //show FVtru and the refine FV
	variable index
	
	string aF=ListFolder()
	DFREF home=getdatafolderDFR()
//	string Imons
	
	variable i,j=0
	for(i=0;i<ItemsInList(aF)-2;i+=1)
		setdatafolder :$stringfromlist(i,aF)
		switch(index)
			case 0:
				setdatafolder FPopen_CaVr
				break
			case 1:
				setdatafolder FPopen_gVr
				break
		endswitch
		string FVName,cmd
		wave Fmons=$"FVTru"
		wave Vmons=$"VSlowTru"
		wave RFmons=$"fit_FVTru"
		setscale/P x,0,0.005,Fmons 
		if(i==0)
			Display/L=FCa Fmons vs Vmons
			ModifyGraph mode(FVTru)=3,marker(FVTru)=19
			appendToGraph/L=FCa RFmons
//			ModifyGraph rgb(RFmons)=(0,0,0)			
		else
			appendToGraph/L=FCa Fmons vs Vmons
			FVName="FVTru#"+num2str(i)
			sprintf cmd, "ModifyGraph mode(%s)=3,marker(%s)=19",FVName,FVName
			execute cmd
			appendToGraph/L=FCa RFmons
//			ModifyGraph rgb(RFmons)=(0,0,0)
		endif

		setdatafolder home
		
	endfor			
end

function DispCorPo()
	string aF=ListFolder()
	DFREF home=getdatafolderDFR()
//	string Imons
	
	variable i,j=0
	
	for(i=0;i<ItemsInList(aF)-2;i+=1)
		setdatafolder :$stringfromlist(i,aF)
		setdatafolder FPopen_CaVr
		wave fPmons=$"fit_Cor_Po"
		if(i==0)
//			setscale/P x,DimOffset(fPmons,0)-0.017,DimDelta(fPmons,0),fPmons
			Display fPmons		
		else
//			setscale/P x,DimOffset(fPmons,0)-0.017,DimDelta(fPmons,0),fPmons		
			appendToGraph fPmons
//			ModifyGraph rgb(RFmons)=(0,0,0)
		endif
	
		setdatafolder home
	endfor
end

function RSCeasy()
	String ImonN=wavelist("*Imon",";","")
	String VmonN=wavelist("*Vmon",";","")
	string wavenote
	string Rseries
	variable Rs
	String Name
	
	variable i
	for(i=0;i<ItemsInList(ImonN);i+=1)
		wave Wi=$stringfromlist(i,ImonN)
		wave Wv=$stringfromlist(i,VmonN)
		wavenote=note(Wi)
		Rseries=stringbykey("\rRsValue",wavenote)
		Rs=str2num(Rseries)*10^6	
		if(Rs==0)
			Rseries=stringbykey("\rRSeries",wavenote)
			Rs=str2num(Rseries)*10^6					
		endif
		Name="CrVmon_"+num2str(i+1)
		make/n=(DimSize(Wv,0)) $Name
		wave w2=$Name	
		w2=Wv+Wi*Rs				
	endfor
end

// Recovery of your leaky leak traces.
// Fitting the depolarization region of the step pulse by a double exponential function,
// and replace the origninal leak trace by this new fitting result.
function/Wave FitReplaceLeak(AvgLeak_Ori)		
	wave AvgLeak_Ori
	
	Duplicate AvgLeak_Ori, AvgLeak
	string NewLeakName= NameOfWave(AvgLeak_Ori)+"_FIt"
	string fitName= "fit_"+"AvgLeak"
		
//	wavestats/Q/R=(0.04,0.06) AvgLeak
	wavestats/Q/R=(0.05,0.09) AvgLeak
	variable Pbegin=x2pnt(AvgLeak,V_maxloc)+1
//	variable Pbegin=pcsr(A)+1
//	variable Pend=x2pnt(AvgLeak,0.12)
	variable Pend=x2pnt(AvgLeak,0.32)
	CurveFit/L=(Pend-Pbegin)/NTHR=0 dblexp_XOffset  AvgLeak[Pbegin,Pend] /D
	wave fitW=$fitName
	
	variable i
	for(i=0;i<Pend-Pbegin;i+=1)
		AvgLeak[i+Pbegin]=fitW[i]
	endfor
	
	rename AvgLeak, $NewLeakName
	wave ReturnW=$NewLeakName
	
	return ReturnW
	
end

function ReplaceAllLeak()
	DFREF home=GetDataFolderDFR()
	LeakBack(0)
	setdatafolder Plus_Leak
	string AuImon=WaveList("uImon*",";","")
	DFREF Dest=GetDataFolderDFR()
	setdatafolder home
	string ALeak=wavelist("*Leak_1",";","")
	variable i
	for(i=0;i<ItemsInList(ALeak);i+=1)
		wave L=$StringFromList(i,ALeak)
		wave FitLeak=FitReplaceLeak(L)
		movewave FitLeak, Dest		
	endfor
	
	SetDataFolder Dest
	string ALeakFit=WaveList("*_Fit",";","")
	for(i=0;i<ItemsInList(ALeakFit);i+=1)
		wave L=$StringFromList(i,ALeakFit)
		wave uImon=$StringFromList(i,AuImon)
		uImon=uImon-L		
	endfor
	
end

/////////////////////****************Activation analysis*******************/////////////////////

function/wave   ActivCurve(I,V,ind)  // for fluorescence
		wave I,V
		variable ind
	
		variable/G gVr
//		wave I=$"I_Avg"
//		wave V=$"V_Avg"
		
		switch(ind)
			case 0:
				curvefit line I[17,21] /X=V
				variable Io=mean(I,0,3)
				wave W_Coef
				break
			case 1:
				variable/G St=pcsr(A)
				variable/G En=pcsr(B)
				curvefit line I[St,En] /X=V
				Io=mean(I,pnt2x(I,4500),pnt2x(I,5500))
				wave W_Coef				
				break
			case 2:
				variable/G ReSt,ReEn  //Set when you click in "Set Points", in the full activation region
				NVAR St,En               //Set when you click in "Set Points", in the null activation region
				curvefit line I[ReSt,ReEn] /X=V		//Calculate the Gmax line	
				Io=mean(I,pnt2x(I,St),pnt2x(I,En))    //Calculate the null activation current 
				break
		endswitch	
					
		wave w_coef		
		variable mp=w_coef[1]  //Slope of the Gmax line
		
		
		duplicate/O I,Pia
		Pia=Pia/(Io+mp*(V-gVr))
		
		switch(ind)
			case 0:
				CurveFit/Q/NTHR=1 Sigmoid  Pia[0,22] /X=V /D
				break
			case 1:
				CurveFit/NTHR=1 Sigmoid  Pia[4500,14500] /X=V /D			
				break
			case 2:
				if(En<St)
					CurveFit/NTHR=1 Sigmoid  Pia[En,ReSt] /X=V /D
				else
					CurveFit/NTHR=1 Sigmoid  Pia[St,ReEn] /X=V /D
				endif	
				break
		endswitch
			
		wave W_Coef
		variable/G Vh=W_Coef[2]
		variable/G k=W_Coef[3]
		wave fit_Pia
		
		variable MiNN,MaXX,n
		n=numpnts(fit_Pia)-1
		MiNN= mean(fit_Pia,pnt2x(fit_pia,0),pnt2x(fit_pia,5))
		Maxx= mean(fit_Pia,pnt2x(fit_pia,n-5),pnt2x(fit_pia,n))
		fit_Pia=(fit_Pia-miNN)/(Maxx-miNN)
		
		return fit_Pia
		
		killwaves W_Coef,W_Sigma
		
end

//////////////////////////////////////////////////COPY//////////////////////////////////////////////////////////////////////////////////
 
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//calculating the reversal potential of F trcae of step protocol
function FrStep(Fmon,Vfmon)
	wave Fmon,Vfmon
	
	duplicate/R=[pcsr(A),pcsr(B)] Fmon, LinearI
	duplicate/R=[pcsr(A),pcsr(B)] Vfmon, LinearV
	CurveFit/NTHR=1 line  LinearI /X=LinearV
	killwaves LinearI,LinearV
	wave W_Coef
	wavestats/R=[0,1] Fmon 
	variable Io=V_avg
	variable/G Fr=(Io-1*W_Coef[0])/W_Coef[1]
	print Fr*1000
	
end

//calculating the reversal potential of F trcae of ramping protocol
function FrRamp(Fmon,Vfmon)
	wave Fmon,Vfmon
	
	duplicate/R=[8,11] Fmon, LinearI
	duplicate/R=[8,11] Vfmon, LinearV
	CurveFit/NTHR=1 line  LinearI /X=LinearV
	killwaves LinearI,LinearV
	wave W_Coef
	wavestats/R=[0,1] Fmon 
	variable Io=V_avg
	variable/G Fr=(Io-1*W_Coef[0])/W_Coef[1]
	print Fr*1000
	
end

//calculating the reversal potential of IV trcae by step protocol
function VrStep(Imon,Vmon)
	wave Imon,Vmon
	
	duplicate/R=[14,18] Imon, LinearI
	duplicate/R=[14,18] Vmon, LinearV
	CurveFit/NTHR=1 line  LinearI /X=LinearV
	killwaves LinearI,LinearV
	wave W_Coef
	wavestats/R=[0,4] Imon 
	variable Io=V_avg
	variable/G Vr=(Io-1*W_Coef[0])/W_Coef[1]
	print Vr*1000
	
end

//calculating the reversal potential of IV trcae by ramping protocol
function VrRamp(Imon,Vmon)
	wave Imon,Vmon
	
	duplicate/R=[pcsr(A),pcsr(B)] Imon, LinearI
	duplicate/R=[pcsr(A),pcsr(B)] Vmon, LinearV
	CurveFit/NTHR=1 line  LinearI /X=LinearV
	killwaves LinearI,LinearV
	wave W_Coef
	wavestats/R=[10,1000] Imon 
	variable Io=V_avg
	variable/G Vr=(Io-1*W_Coef[0])/W_Coef[1]
	print Vr*1000
	
end

//Refine the FV trace
//1. finding the 3 points: Vm=-70mV at the onset of ramp, Vm=15mV ,Vm=30mV
//2. calculating reversal potential from raw FV trace by Vm=15mV and 30mV
//to be continued


//Normalizing the FV trace
Function TraceNorm(keyword,type)
	string Keyword
	variable type //**type=0, F, type=1,I
	string allwaves=wavelist(keyword,";","")
	string name
	variable maxi,avg
	variable i
	for(i=0;i<ItemsInList(allwaves);i+=1)
		name = stringfromlist(i,allwaves)+"_Norm"
		duplicate/O $stringfromlist(i,allwaves), $Name
		wave w=$Name
		avg=mean(w)
		switch(type)
			case 1:
				maxi=wavemin(w,pnt2x(w,10000),pnt2x(w,13000))-avg
				w=(avg-w)/maxi
				break
			case 0:
				maxi=wavemax(w)-avg
				w=w/maxi
				break
		endswitch		
	endfor
end 


//part I :Estimate the reversal potential Vr, by cursor
//  	     Need: Imon, Vmon Output: Vr
//part II :by means of Vr, fitting the slope (+15mV to +30mV) of FV
// F(V)=m(V-Vr)/exp(Vh-V/k), get m
//         Need: F(V), Vr,Vmon      Output: m, Vh,k
function   BoltzmannFV()
		
	wave Imon=$stringfromlist(0,wavelist("PDep*",";",""))
	wave Vmon=$stringfromlist(0,wavelist("VmonC*","",""))
	wave Vslow=$stringfromlist(0,wavelist("VmonS*","",""))
	wave FV=$stringfromlist(0,wavelist("Avg*","",""))
	
	variable i=0
	
	do 
		i=i+1	
	while(Vmon[i]<-0.07 && i<DimSize(Vmon,0))
	variable Point0=i
	
	do 
		i=i+1	
	while(Vmon[i]<0.01 && i<DimSize(Vmon,0))
	variable Point1=i

	do 
		i=i+1	
	while(Vmon[i]<0.025 && i<DimSize(Vmon,0))	
	variable point2=i
	

	duplicate/R=[Point1,Point2] Imon, LinearI
	duplicate/R=[Point1,Point2] Vmon, LinearV
	
	CurveFit/NTHR=1 line  LinearI /X=LinearV
	killwaves LinearI,LinearV
	wave W_Coef
	wavestats/R=[0,point0] Imon 
	variable Io=V_avg
	variable/G Vr=(Io-1*W_Coef[0])/W_Coef[1]
	print Vr*1000
	////// part II //////
	
	i=0
	
	do 
		i=i+1	
	while(Vslow[i]<-0.07 && i<DimSize(VSlow,0))
	Point0=i
	
	do 
		i=i+1	
	while(Vslow[i]<0.015 && i<DimSize(VSlow,0))
	Point1=i

	do 
		i=i+1	
	while(Vslow[i]<0.025 && i<DimSize(VSlow,0))	
	point2=i
	
print point0,point1,point2
	
	variable avg70to60
	wavestats/R=[point0,point0+2] FV
	avg70to60=V_Avg
	variable mp=(FV[point1]-avg70to60)/(Vslow[point1]-Vr)	
	print mp
	
	make/n=(point1-Point0+1) PopenP
	for(i=point0;i<=Point1;i+=1)
		PopenP[i-point0]=(FV[i]-avg70to60)/(mp*(Vslow[i]-Vr))		
	endfor
	
	duplicate/R=[point0,point1] Vslow, VslowTru
	duplicate/R=[point0,point1] FV, FVTru

	CurveFit/N/NTHR=0 Sigmoid  PopenP /X=VslowTru /D
	wave w_Coef 
	
	make/O/n=(5,3) IniGuess
	
	IniGuess[0][0]=avg70to60
	IniGuess[1][0]=mp
	IniGuess[2][0]=Vr
	IniGuess[3][0]=W_Coef[2]
	IniGuess[4][0]=W_Coef[3]
	IniGuess[0][1]=5
	IniGuess[1][1]=1000
	IniGuess[2][1]=1
	IniGuess[3][1]=0.005
	IniGuess[4][1]=0.01	
	IniGuess[][3]=IniGuess[p][0]
	duplicate/O/R=[point0,point2] Vslow, VslowTru
	duplicate/O/R=[point0,point2] FV, FVTru
	
	FuncFit/NTHR=1 FluoVoltage,IniGuess[][0],FVTru /X=VslowTru/D 
	wave Fit_FVTru
	Differentiate fit_FVTru/D=d_fit
	setscale/P x,VSlowTru[0],0.005,FVTru
	
	i=0
	do
		i=i+1
	while(d_fit[i+1]*d_fit[i]>0 && i<dimsize(d_fit,0))
	Variable Px=i+5
	variable/G Xv=pnt2x(d_fit,Px)
	mp=(Fit_FVTru[Px]-Avg70to60)/(Xv-Vr)
	
	print mp
	
	make/O/n=(Px+1) Cor_Po
	
	for(i=0;i<=Px;i+=1)
		Cor_Po[i]=(fit_FVTru[i]-fit_FVTru[0])/(mp*(pnt2x(fit_FVTru,i)-Vr))		
	endfor
	setscale/P x,dimoffset(fit_FVTru,0),dimdelta(fit_FVTru,0),Cor_Po
	CurveFit/N/NTHR=0 Sigmoid  Cor_Po /D
end


// This function fitting the FV traces instead of the Boltzmann traces
Function FluoVoltage(w,V) : FitFunc
	Wave w
	Variable V
	
//	NVAR Vr

	//CurveFitDialog/ These comments were created by the Curve Fitting dialog. Altering them will
	//CurveFitDialog/ make the function less convenient to work with in the Curve Fitting dialog.
	//CurveFitDialog/ Equation:
	//CurveFitDialog/ f(V) = m*(V-Vr)/1+exp((Vh-V)/k)
	//CurveFitDialog/ End of Equation
	//CurveFitDialog/ Independent Variables 1
	//CurveFitDialog/ V
	//CurveFitDialog/ Coefficients 4
	//CurveFitDialog/ w[0] = Fo
	//CurveFitDialog/ w[1] = m
	//CurveFitDialog/ w[2] = Vh
	//CurveFitDialog/ w[3] = k
	variable/G Vr


	return w[0]+(((w[1]*(Vr-V))/(1+exp((w[2]-V)/w[3]))))
End

Function FluoVoltage2(w,V) : FitFunc  //Fix baseline as 0
	Wave w
	Variable V
	
//	NVAR Vr

	//CurveFitDialog/ These comments were created by the Curve Fitting dialog. Altering them will
	//CurveFitDialog/ make the function less convenient to work with in the Curve Fitting dialog.
	//CurveFitDialog/ Equation:
	//CurveFitDialog/ f(V) = m*(V-Vr)/1+exp((Vh-V)/k)
	//CurveFitDialog/ End of Equation
	//CurveFitDialog/ Independent Variables 1
	//CurveFitDialog/ V
	//CurveFitDialog/ Coefficients 4
	//CurveFitDialog/ w[0] = mp
	//CurveFitDialog/ w[1] = Vr
	//CurveFitDialog/ w[2] = Vh
	//CurveFitDialog/ w[3] = k


	return ((w[0]*(w[1]-V))/(1+exp((w[2]-V)/w[3])))
End





//***************************************************************************************************************//
//*************************************************09.10.2013*************************************************//
#pragma rtGlobals=3		// Use modern global access method and strict wave access.


function AllIV()
	string AF=ListFolders("*")
	DFREF home=GetDataFolderDFR()
	variable i
	string grN=WinName(0,1)	
	
	for(i=0;i<ItemsInList(AF)-1;i+=1)
		setdatafolder :$stringfromlist(i,AF)
		wave/Z I_avg,V_avg
		if(waveexists(I_avg)==1)
			killwaves I_Avg			
		endif	

		if(waveexists(V_avg)==1)
			killwaves V_Avg			
		endif	
		
		AutoIV(0,1,grn) //*first: steady-state or peak current, second: zero correct or not (0: not)
		
		wave Iavg_peak
       	wave Vavg_peak
		if(i==0)
			display/B=V/R=I  Iavg_peak vs Vavg_peak
		else
			AppendToGraph/B=V/R=I Iavg_peak vs Vavg_peak
		endif
		setdatafolder home
	endfor

end

Function AutoIV(indA,indB,grN)
		variable indA //0,steady-state,1 peak
		variable indB //0, raw current, 1 corrected current for Io, rS is anyway corrected by raw current
		string grN
		
		string keyC="*_Imon"
		string keyV="*_Vmon"
		variable rA
		variable rB
	

		String ALLIwaves = Wavelist(keyC,";","")
		String ALLVwaves= Wavelist(keyV,";","")
		
		switch(indA)
			case 0:
				wave/Z Iavg_peak,Vavg_peak
				if(waveexists(Iavg_peak)==1)
					killwaves Iavg_peak, Vavg_peak
				endif
				make/O/n=(ItemsInList(allIwaves)) Iavg_Peak
				make/O/n=(ItemsInList(allVwaves)) Vavg_Peak
				wave Iavg=$"Iavg_Peak"
				wave Vavg=$"Vavg_Peak"
			break
			case 1:
				wave/Z Iavg_Peak,Vavg_Peak
				if(waveexists(Iavg_peak)==1)
					killwaves Iavg_peak,Vavg_peak
				endif
				make/O/n=(ItemsInList(allIwaves)) Iavg_peak
				make/O/n=(ItemsInList(allVwaves)) Vavg_peak
				wave Iavg=$"Iavg_peak"
				wave Vavg=$"Vavg_peak"				
			break
		endswitch	
		

		
		variable i	
		
		string wavenote,Rseries,name
		variable Rs
		variable minV
		
		for(i=0; i<ItemsInList(allIwaves);i+=1)		
			wave w=$stringfromlist(i,ALLIwaves,";")
			switch(indA)
				case 0:
					rA=xcsr(A,grn)
					rB=xcsr(B,grn)
				break
				case 1:
					wavestats/Q/R=(0.0105,0.014) w
					rA=pnt2x(w,V_minRowLoc-25)
					rB=pnt2x(w,V_minRowLoc+25)
				break
			endswitch
			
			Iavg[i] =  mean($StringFromList(i,ALLIwaves,";"),rA,rB)
						
			wave Imon=$StringFromList(i,ALLIWaves,";")
			wavenote=note(Imon)
			Rseries=stringbykey("\rRsValue",wavenote)
			Rs=str2num(Rseries)*10^6
			if(Rs==0)
				Rs=str2num(stringbykey("\rRseries",wavenote))*10^6
			endif
			wave Vmon=$StringFromList(i,ALLVwaves,";")
			make/O/n=(DimSize(Vmon,0)) TempVmon
			TempVmon=Vmon-Imon*Rs
			Setscale/P x,Dimoffset(Vmon,0),deltax(Vmon),TempVmon			
			Vavg[i] = mean(TempVmon,rA,rB)
			name="Vmon"+num2str(i)
//			rename TempVmon, $name
			killwaves TempVmon			
		endfor
		
		
		if( IndB==1 )
			variable Io = mean(Iavg , pnt2x(Iavg,0), pnt2x(Iavg,3))
			Iavg = Iavg - Io 
		endif

End

function showIV()

	variable i
	string AF=ListFolder()
	DFREF home=GetDataFolderDFR()
	
	for(i=0;i<ItemsInList(AF)-1;i+=1)
		SetDataFolder :$StringFromList(i,AF)
		wave Iavg=$"Iavg_peak"
		wave Vavg=$"Vavg_peak"
		if(waveexists(Iavg)==0)
			continue
		endif
		
		duplicate/O Iavg, home:Iavg
		duplicate/O Vavg, home:Vavg
		
//		if(i==0)
//			display/B=V/R=I Iavg vs Vavg
//		else
//			appendtograph/B=V/R=I Iavg vs Vavg
//		endif
		setdatafolder home
		
		wave Iavg,Vavg
		
		concatenate/NP=1 {Iavg}, I_total
		concatenate/NP=1 {Vavg}, V_total		
	endfor

	make/O/n=(DimSize(I_total,0)) I_mean,I_SEM
	make/O/n=(DimSize(V_total,0)) V_mean,V_SEM
	for(i=0;i<DimSize(Iavg,0);i+=1)
		duplicate/R=[i,i][0,DimSize(I_total,1)] I_total,Row 
		matrixtranspose Row
		redimension/n=(-1,0,0,0) Row
		I_mean[i]=mean(Row)
		I_SEM[i]=sqrt(variance(row)/Dimsize(Row,0))
		killwaves Row
		duplicate/R=[i,i][0,DimSize(I_total,1)] V_total,Row 
		matrixtranspose Row
		redimension/n=(-1,0,0,0) Row
		V_mean[i]=mean(Row)
		V_SEM[i]=sqrt(variance(row)/Dimsize(Row,0))
		killwaves Row				
	endfor

end

function GetSEM()
	wave Iw=$"Pia_Total"
//	wave Vw=$"V_total_End"
	
	variable i
	make/n=(DimSize(Iw,0)) Pia_SEM, Pia_mean
//	make/n=(DimSize(Iw,0)) V_SEM_Peak,V_mean_Peak
	for(i=0;i<DimSize(Iw,0);i+=1)
		duplicate/R=[i,i][] Iw, TempIw
		matrixtranspose TempIw
		redimension/N=(-1,0) TempIw
		Pia_SEM[i]=sqrt(variance(TempIw)/DimSize(Iw,1))
		Pia_mean[i]=mean(TempIw)
//		duplicate/R=[i,i][] Vw, TempVw
//		matrixtranspose TempVw
//		redimension/N=(-1,0) TempVw
//		V_SEM_Peak[i]=sqrt(variance(TempVw)/DimSize(Vw,1))
//		V_mean_Peak[i]=mean(TempVw)
		killwaves TempIw//,TempVw
	endfor
	
end


	



